﻿using System.Runtime.Serialization.Formatters.Binary;
using System.IO;

namespace HelloEncryptedFluent.Encrypted
{
    public class BinaryConverter : IBinaryConverter
    {
        public byte[] Serialize(object obj)
        {
            using(var stream = new MemoryStream())
            {            
                var formatter = new BinaryFormatter();
                formatter.Serialize(stream, obj);
                return stream.ToArray();
            }
        }

        public object Deserialize(byte[] bytes)
        {            
            using (var stream = new MemoryStream(bytes))
            {
                var formatter = new BinaryFormatter();
                return formatter.Deserialize(stream);
            }
        }
    }
}
