﻿using System.IO;
using System.Security.Cryptography;

namespace HelloEncryptedFluent.Encrypted
{
    public class  EncryptionService : IEncryptionService
    {
        private byte[] key = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24 };
        private byte[] iv = { 1, 2, 3, 4, 5, 6, 7, 8 };

        public byte[] Encrypt(byte[] cipher)
        {
            byte[] result;
            using (var desCryptoServiceProvider = new TripleDESCryptoServiceProvider())
            {
                desCryptoServiceProvider.Key = key;
                desCryptoServiceProvider.IV = iv;
                using (MemoryStream memStream = new MemoryStream())
                {
                    using (CryptoStream cryptoStream = new CryptoStream(memStream, desCryptoServiceProvider.CreateEncryptor(), CryptoStreamMode.Write))
                    {
                        cryptoStream.Write(cipher, 0, cipher.Length);
                        cryptoStream.FlushFinalBlock();
                        result = memStream.ToArray();
                        memStream.Close();
                        cryptoStream.Close();
                    }
                }
            }
            return result;
        }

        public byte[] Decrypt(byte[] cipher)
        {
            byte[] result;
            using (var desCryptoServiceProvider = new TripleDESCryptoServiceProvider())
            {
                desCryptoServiceProvider.Key = key;
                desCryptoServiceProvider.IV = iv;
                using (MemoryStream memoryStream = new MemoryStream())
                {
                    using (CryptoStream decryptoStream = new CryptoStream(memoryStream, desCryptoServiceProvider.CreateDecryptor(), CryptoStreamMode.Write))
                    {
                        decryptoStream.Write(cipher, 0, cipher.Length);
                        decryptoStream.FlushFinalBlock();
                        result = memoryStream.ToArray();
                        memoryStream.Close();
                        decryptoStream.Close();
                    }
                }
            }
            return result;
        } 

        private byte[] XORCrypt(byte[] cipher)
        {
            byte[] result = new byte[cipher.LongLength];
            for (long i = 0; i < cipher.LongLength; i++)
            {
                result[i] = (byte)(cipher[i] ^ 42);
            }
            return result;
        }
    }
}
