﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Mapping;
using HelloEncryptedFluent.Encrypted;
using HelloEncryptedFluent.Entities;

namespace HelloEncryptedFluent.Mappings
{
    public class BlogMap : ClassMap<Blog>
    {
        public BlogMap()
        {
            Id(x => x.Id);
            Map(x => x.Title).CustomType(typeof(EncryptedType<string>));
            Map(x => x.Rank).CustomType(typeof(EncryptedType<int>));
            Map(x => x.IsPublished).CustomType(typeof(EncryptedType<bool>));            
        }
    }
}
