﻿using System;
using FluentNHibernate.Cfg;
using HelloEncryptedFluent.Entities;
using NHibernate;
using NHibernate.Cfg;
using NHibernate.Criterion;
using NHibernate.Tool.hbm2ddl;

namespace HelloEncryptedFluent
{
    class Program
    {
        static void Main(string[] args)
        {            
            var sessionFactory = CreateSessionFactory();
            
            using (var session = sessionFactory.OpenSession())
            {                
                using (var transaction = session.BeginTransaction())
                {
                    var blog1 = new Blog() { Title = "blog1", IsPublished = true, Rank = 10};
                    session.SaveOrUpdate(blog1);
                    var blog2 = new Blog() { Title = "blog2" };
                    session.SaveOrUpdate(blog2);
                    transaction.Commit();
                }
            }

            using (var session = sessionFactory.OpenSession())
            {                
                using (session.BeginTransaction())
                {
                    var blogs = session.CreateCriteria(typeof(Blog))
                        .Add(Restrictions.Eq("Title", "blog1"))
                        .List<Blog>();
                    foreach (var blog in blogs)
                    {
                        Console.WriteLine("{0} => {1} | {2} | {3} ", blog.Id, blog.Title, blog.Rank, blog.IsPublished);
                    }
                }
            }
        }


        private static ISessionFactory CreateSessionFactory()
        {
            return Fluently.Configure()
                .Mappings(m => m.FluentMappings.AddFromAssemblyOf<Program>())
                .ExposeConfiguration(BuildSchema)
                .BuildConfiguration()                
                .BuildSessionFactory();
        }


        private static void BuildSchema(Configuration config)
        {            
            new SchemaExport(config)
                .Create(false, true);
        }

    }
}
