﻿using System.Linq;

namespace Orchard.Scripting.Ast {
    public class AstVisitor {
        public virtual object Visit(AstNode node) {
            return node.Accept(this);
        }

        public virtual object VisitChildren(AstNode node) {
            return node.Children.Aggregate<AstNode, object>(null, (prev, child) => Visit(child));
        }

        public virtual object VisitBinary(BinaryAstNode node) {
            return null;
        }

        public virtual object VisitConstant(ConstantAstNode node) {
            return null;
        }

        public virtual object VisitError(ErrorAstNode node) {
            return null;
        }

        public virtual object VisitUnary(UnaryAstNode node) {
            return null;
        }

        public virtual object VisitMethodCall(MethodCallAstNode node) {
            return null;
        }
    }
}