using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Http.Dependencies;
using Autofac;

namespace Orchard.WebApi {
    public class AutofacWebApiDependencyScope : IDependencyScope {
        readonly ILifetimeScope _lifetimeScope;

        public AutofacWebApiDependencyScope(ILifetimeScope lifetimeScope) {
            _lifetimeScope = lifetimeScope;
        }

        public object GetService(Type serviceType) {
            return _lifetimeScope.ResolveOptional(serviceType);
        }

        public IEnumerable<object> GetServices(Type serviceType) {
            if (!_lifetimeScope.IsRegistered(serviceType))
                return Enumerable.Empty<object>();

            var enumerableServiceType = typeof(IEnumerable<>).MakeGenericType(serviceType);
            var instance = _lifetimeScope.Resolve(enumerableServiceType);
            return (IEnumerable<object>)instance;
        }

        public void Dispose() {
            if (_lifetimeScope != null)
                _lifetimeScope.Dispose();
        }
    }
}